import os, sys
#sys.path.append(os.path.join(os.path.dirname(__file__), "output"))
#sys.path.append(os.path.join(os.path.dirname(__file__), "output/nanovoid_cpp_v1_128"))

#from chash_bucket import bl
#from chash_bucket_ns101_K3_L10 import bl
#from bucket import bl
import numpy as np

import matplotlib.pyplot as plt

def parse_bucket_out(filename):
    with open(filename, 'r') as f:
        l = f.readline()
        items = l[:-1].split(']')
        bl = []
        for item in items:
            if len(item) == 0:
                continue
            st = 0
            while not item[st] in '0123456789':
                st += 1
            ed = len(item)-1
            while not item[ed] in '0123456789':
                ed -= 1
            num_strs = item[st:(ed+1)].split(',')
            nums = [int(itm) for itm in num_strs]
            bl.append(nums)
        f.close()
        return bl

##### Main Program #####
size = 1024

#filename = "output/nanovoid_cpp_v1_128/bucket.py"
filename = "output/nanovoid_cpp_multi1_N1024_c20_r25_std2/bucket.py"
bl = parse_bucket_out(filename)

print('len(bl)=', len(bl))
print(bl)

colors = np.random.uniform(size=(len(bl), 3))

#print('colors=', colors)

c = np.zeros((size, size, 3))
print('c.shape=', c.shape)
print('len(bl)=', len(bl))

for i, bucket in enumerate(bl):
    #print(i, bucket)
    for pixel_itm in bucket:
        #print('pixel_itm=', pixel_itm)
        x = int(pixel_itm) // int(size)
        y = pixel_itm % size
        #print('x=', x, 'y=', y)
        c[x,y,:] = colors[i,:]

plt.imshow(c)
plt.show()



